/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config;

import frc.emul.config.Configuration;
import frc.emul.config.handler.ConfigLoaderContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ConfigLoader
implements ErrorHandler {
    private ConfigLoaderContext ctx;

    public final Configuration load(String string, String[] stringArray) {
        Configuration configuration = this.load(string);
        configuration.override(stringArray);
        return configuration;
    }

    public final Configuration load(String string) {
        return this.load(string, false);
    }

    /*
     * Unable to fully structure code
     */
    public final Configuration load(String var1_1, boolean var2_2) {
        block28: {
            if (var1_1 == null || var1_1.length() == 0) {
                if (var2_2) {
                    return null;
                }
                System.err.println("*** Error : no configuration filename provided, aborting!");
                System.exit(-1);
            }
            var3_3 = null;
            try {
                var3_3 = Thread.currentThread().getContextClassLoader().getResourceAsStream(var1_1);
            }
            catch (Exception v0) {}
            try {
                if (var3_3 == null) {
                    var3_3 = new FileInputStream(var1_1);
                }
            }
            catch (Exception v1) {}
            if (var3_3 != null) ** GOTO lbl29
            if (!var2_2) break block28;
            try {
                if (var3_3 != null) {
                    var3_3.close();
                }
            }
            catch (Exception v2) {}
            return null;
        }
        System.err.println("*** Error while opening configuration file [" + var1_1 + "], aborting!");
        System.exit(-1);
lbl29:
        // 2 sources

        var6_6 = var4_4 = this.load(var3_3, var1_1);
        try {
            if (var3_3 != null) {
                var3_3.close();
            }
        }
        catch (Exception v3) {}
        return var6_6;
        catch (Exception var4_5) {
            block29: {
                try {
                    if (!var2_2) break block29;
                }
                catch (Throwable var5_7) {
                    try {
                        if (var3_3 != null) {
                            var3_3.close();
                        }
                    }
                    catch (Exception v4) {}
                    throw var5_7;
                }
                try {
                    if (var3_3 != null) {
                        var3_3.close();
                    }
                }
                catch (Exception v5) {}
                return null;
            }
            System.err.println("*** Error while loading configuration file [" + var1_1 + "], aborting!");
            var4_5.printStackTrace(System.err);
            System.exit(-1);
            try {
                if (var3_3 != null) {
                    var3_3.close();
                }
            }
            catch (Exception v6) {}
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized Configuration load(InputStream inputStream, String string) {
        Configuration configuration;
        XMLReader xMLReader = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            xMLReader = sAXParser.getXMLReader();
            this.ctx = new ConfigLoaderContext(xMLReader, string);
            xMLReader.setErrorHandler(this);
            xMLReader.parse(ConfigLoader.openInputSource(inputStream));
            configuration = (Configuration)this.ctx.getRootObject();
            this.ctx = null;
        }
        catch (Throwable throwable) {
            try {
                if (xMLReader != null) throw new RuntimeException("Failed to load the XML configuration file", throwable);
                throw new RuntimeException("Failed to instanciate an XML reader for the configuration loader.", throwable);
            }
            catch (Throwable throwable2) {
                this.ctx = null;
                try {
                    inputStream.close();
                    throw throwable2;
                }
                catch (Exception exception) {}
                throw throwable2;
            }
        }
        try {
            inputStream.close();
            return configuration;
        }
        catch (Exception exception) {}
        return configuration;
    }

    public void warning(SAXParseException sAXParseException) {
        System.err.println("*** " + this.appendLocation("Configuration file parsing warning"));
        sAXParseException.printStackTrace(System.err);
    }

    public void error(SAXParseException sAXParseException) {
        System.err.println("*** " + this.appendLocation("Configuration file parsing error"));
        sAXParseException.printStackTrace(System.err);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("*** " + this.appendLocation("FATAL ERROR during configuration file parsing"));
        sAXParseException.printStackTrace(System.err);
        throw new RuntimeException("Configuration file parsing fatal error");
    }

    private final String appendLocation(String string) {
        Locator locator = this.ctx.getLocator();
        if (locator == null) {
            return String.valueOf(string) + " at undefined location.";
        }
        return String.valueOf(string) + " at line " + locator.getLineNumber() + ", column " + locator.getColumnNumber() + ".";
    }

    public static final InputSource openInputSource(InputStream inputStream) throws IOException {
        InputSource inputSource = new InputSource();
        inputSource.setEncoding("UTF-8");
        inputSource.setByteStream(inputStream);
        return inputSource;
    }
}

